/*---------------------------------------------------------------------
C-  Function:	OverlandChemicalPhotolysis.c
C-
C-	Purpose/	Compute the photolysis flux of chemicals in the
C-	Methods:	channel network.  Chemical photolysis is assumed
C-				to occur at the same rate for all chemical phases.
C-
C-
C-  Inputs:	    channel properties,
C-              kphtwch[], kphtsch[]
C-
C-  Outputs:    phtchemchoutflux[][][][]
C-
C-  Controls:   imask[][], phtopt[]
C-
C-  Calls:      None
C-
C-  Called by:  OverlandChemicalKinetics
C-
C-	Created:	Mark Velleux
C-              Department of Civil Engineering
C-              Colorado State University
C-              Fort Collins, CO  80523
C-
C-	Date:		15-MAY-2005
C-
C-	Revised:
C-
C-	Date:
C-
C-	Revisions:
C-
C----------------------------------------------------------------------*/

//trex global variable declarations
#include "trex_general_declarations.h"

//trex global variable declarations for water transport
#include "trex_water_declarations.h"

//trex global variable declarations for sediment transport
#include "trex_solids_declarations.h"

//trex global variable declarations for chemical transport
#include "trex_chemical_declarations.h"

//trex global variable declarations for environmental conditions
#include "trex_environmental_declarations.h"

void OverlandChemicalPhotolysis()
{

//End of function: Return to OverlandChemicalKinetics
}
