% This file builds the interconnections for the 
% ECE612 Design Project.

% Define all the weights and the plant

w1_wt = 1;  
w2_wt = 1e-2;                 % This weight must NOT be strictly proper
z1_wt = zpk([],-100,100);  % This weight MUST be strictly proper                 
z2_wt = 1;                    % This weight must NOT be strictly proper

plant = zpk(1,[-1;2],1);
[ap,bp,cp,dp] = ssdata(plant); % For Simulink to use

% Build the interconnection: sys_con 

systemnames = ' w1_wt w2_wt z1_wt z2_wt plant ';

inputvar = '[ w(2); u(1) ]';                   % Inputs  [w;u]
outputvar = '[ z1_wt; z2_wt; w1_wt+w2_wt-plant ]';   % Outputs [z;y]

input_to_w1_wt = '[ w(1) ]';
input_to_w2_wt = '[ w(2) ]';
input_to_z1_wt = '[ w1_wt-plant ]';
input_to_z2_wt = '[ u ]';
input_to_plant = '[ u ]';

sysoutname = 'sys_con';
cleanupsysic = 'yes';
sysic

sys_con_full = ss(sys_con);
sys_con = minreal(sys_con_full);

% Define extra variables

ny = 1;
nu = 1;

disp(' ')
disp('Interconnection Built')
disp(' ')






