% This file carries out a H_infinity design for the 
% ECE612 design project.

% It assumes you have run makplant to define all 
% the appropriate quantities

% Do the H_infinity design

% Set the values for the gamma iteration

gam_min = 1;
gam_max = 100;
gam_tol = 1;

[k_hi,cloop_hi] = hinfsyn(sys_con,ny,nu,gam_min,gam_max,gam_tol);

[ak,bk,ck,dk] = ssdata(k_hi);  % For Simulink to use

% Now check the answers

[dum1,dum2,dum3,states] = minfo(k_hi);

controller_order = states

stability_check = max(real(pole(cloop_hi)))

h2_norm = norm(cloop_hi,2)    % H2 norm of closed loop in cont time

hi_norm = norm(cloop_hi,inf)   % H_infinity norm of closed loop in cont time

