% This file carries out a H2 design for the 
% ECE612 design project.

% It assumes you have run makplant to define all 
% the appropriate quantities

% Do the H2 design

[k_h2,cloop_h2] = h2syn(sys_con,ny,nu);

[ak,bk,ck,dk] = ssdata(k_h2);  % For Simulink to use

% Now check the answers

[dum1,dum2,dum3,states] = minfo(k_h2);

controller_order = states

stability_check = max(real(pole(cloop_h2)))

h2_norm = norm(cloop_h2,2)    % H2 norm of closed loop in cont time

hi_norm = norm(cloop_h2,inf)   % H_infinity norm of closed loop in cont time


