function [] = fit(final, I)
% Edge display and circle fitting function
% Displays thick line along calculated edge, and fits circle to
% boundary pixels.

%% Show edge
% Read in and display a binary image. Overlay the region boundaries on the
% image. Display text showing the region number (based on the label matrix)
% next to every boundary. Additionally, display the adjacency matrix using 
% the MATLAB spy function.
% After the image is displayed, use the zoom tool to read individual labels.

[B,L,N,A] = bwboundaries(final);
figure, imshow(I); hold on;
colors=['b' 'g' 'r' 'c' 'm' 'y'];
for k=1:length(B)
    boundary = B{k};
    cidx = mod(k,length(colors))+1;
    plot(boundary(:,2), boundary(:,1),...
         colors(cidx),'LineWidth',2);
    %randomize text position for better visibility
    rndRow = ceil(length(boundary)/(mod(rand*k,7)+1));
    col = boundary(rndRow,2); row = boundary(rndRow,1);
    h = text(col+1, row-1, num2str(L(row,col)));
    set(h,'Color',colors(cidx),...
        'FontSize',14,'FontWeight','bold');
end

%% Fit a Circle to the data

% if figure border is recognized as object because of binning 
% replace with the following line

% boundary = B{1};
boundary = B{2};
[xfit,yfit,Rfit] = singleCirFit(boundary(:,2), boundary(:,1), I);
