function  H = entropy(I,kerSize)

% ENTROPY
% Compute the Shannon entropy of an image.
% H = entropy(I,kerSize), where
%
% I       - The image being scanned
% kerSize - The nxn size of the kernel being used
% H       - The new image after entropy scan


%% Initialize variables

[height,width] = size(I);           % Dimentions of orig. image
H = ones(height,width) * 2;         % New empty matrix (new image)
kerSize = int32(kerSize);           % Make sure kerSize is an int
border = idivide(kerSize,2);        % Border = (kerSize - 1)/2

%% Histogram technique

for i=1+border:height-border
    for j=1+border:width-border
        tempMat = I(i-border:i+border, j-border:j+border);
        [p x] = imhist(tempMat, 256);
        
        %%%
        p = p + .0001;                 % (eliminate NaNs)
        %%%
        
        p = p./(double(kerSize^2));
        H(i,j) = (-sum(p.*log10(p)));
    end
end


%% Normalize
const = 255/max(max(H));
H = H*const;

%% Convert to unsigned 8bit
H = uint8(H);