function   [xc,yc,R,a] = circfit(x,y)
%
% [xc yc R] = circfit(x,y)
%
% Fits a circle in (x,y) plane.
% x,y are column vector where (x(i),y(i)) is a measured point.
% Result is center point (yc,xc) and radius R.
% An optional output is the vector of coeficient a
% describing the circle's equation
%
% x^2 + y^2 + a(1)*x + a(2)*y + a(3) = 0
%
% By:  Izhak bucher 25/oct /1991

x=x(:); y=y(:);
a=[x y ones(size(x))]\[-(x.^2+y.^2)];
xc = -.5*a(1);
yc = -.5*a(2);
R  =  sqrt((a(1)^2+a(2)^2)/4-a(3));