function [H CE NF final ] = MAIN(I)
% MAIN for Entropy image enhancement
% TIC-TOC to determine elapsed time of script

%% start clock for time check
tic


%% Histogram of original image
figure, imhist(I), title('Histogram of original image');

%% kernel size of 19, find time to calculate
window = 19;
H = entropy(I,window);

%% Preform linear histogram expansion
CE = imadjust(H);

%% Filter with single Gaussian filter
% Kernel size passed through 'nanoFilter.m' is 41 pixels.
NF = GausFilter(CE, 41, 10);
figure, imhist(NF), ylim auto, title('Histogram of smoothed entropy image');
%
% The next line plots a cross section of 1024x1024 image
%figure, plot(1:1024, NF(512,:)), xlim([0 1024]), title('Plot along row 512 of Gaussian filtered image');


%% Converts image to binary, and runs circle fitting algorithm,
%  along with displaying calculated edge.
PBW = im2bw(NF, .333333333);
iPBW = ~PBW;
BW2 = bwareaopen(iPBW, 1000);
final = GausFilter(BW2, 31, 2);
fit(final, I);

%% give elapsed time
toc