function [S1] = NANOPORE()
clear
clc

%% Read in images
cd 'Nanopore_Images'
I = imread('nanopore.tif');
cd ..

%% Binning options
% When binning is used, change index in line 35 of fit.m
%I = imresize(I, 0.5, 'bilinear');
%I = imresize(I, 0.25, 'bicubic');


%% Run algorithm, retrieve images
[H1 CE1 NF1 PBW1] = Shannon(I);


%% Create structures for output
 S1 = struct('I', I, 'CE', CE1, 'H', H1, 'NF', NF1, 'PBW', PBW1);
